/*
 * tclDataTypes.h
 *
 *  Created on: Sep 4, 2012
 *      Author: rjk2hi
 */

#ifndef TCLDATATYPES_H_
#define TCLDATATYPES_H_

#include <dbus/dbus.h>
#include <stdint.h>

enum T_e8_DbusErrorCode
{
	/*
	 * No Error
	 */
	DBERR_NONE = 0,
	/*
	 * Error occured in getting a bus connection
	 */
	DBERR_BUS_GET_FAILURE = 1,
	/*
	 * Request service name over bus failed
	 */
	DBERR_REQ_SERVICE_NAME_FAILED = 2,
	/*
	 * Connection is invalid
	 */
	DBERR_CONN_INVALID = 3,
	/*
	 * Adding Dbus watch set failed
	 */
	DBERR_SET_WATCH_FAILED= 4,
	/*
	 * Adding Dbus timer set failed
	 */
	DBERR_SET_TIMER_FAILED= 5,

	DBROR_MAX
};

enum T_e8_ContainerType
{
	CONTAINER_TYPE_INVALID = 0,
	CONTAINER_TYPE_ARRAY = DBUS_TYPE_ARRAY,
	CONTAINER_TYPE_VARIANT = DBUS_TYPE_VARIANT,
	CONTAINER_TYPE_STRUCT = DBUS_TYPE_STRUCT,
	CONTAINER_TYPE_DICT_ENTRY = DBUS_TYPE_DICT_ENTRY,
};

enum T_e8_internalerror_e
{
	/**
	 * no error - positive reply
	 */
	E_OK = 0,
	/**
	 * default
	 */
	E_UNKNOWN = 1,
	/**
	 * value out of range
	 */
	E_OUT_OF_RANGE = 2,
	/**
	 * not used
	 */
	E_NOT_USED = 3,
	/**
	 * a database error occurred
	 */
	E_DATABASE_ERROR = 4,
	/**
	 * the desired object already exists
	 */
	E_ALREADY_EXISTS = 5,
	/**
	 * there is no change
	 */
	E_NO_CHANGE = 6,
	/**
	 * the desired action is not possible
	 */
	E_NOT_POSSIBLE = 7,
	/**
	 * the desired object is non existent
	 */
	E_NON_EXISTENT = 8,
	/**
	 * the asynchronous action was aborted
	 */
	E_ABORTED = 9,
	/**
	 * This error is returned in case a connect is issued with a connectionFormat that
	 * cannot be selected for the connection. This could be either due to the
	 * capabilities of a source or a sink or gateway compatibilities for example
	 */
	E_WRONG_FORMAT = 10,
	E_MAX
};

/*
 * Generic Container for 10 items
 */
//No values for invalid type
struct InvalidType
{
};

template <
typename T1,
         typename T2 = InvalidType,
         typename T3 = InvalidType,
         typename T4 = InvalidType,
         typename T5 = InvalidType,
         typename T6 = InvalidType,
         typename T7 = InvalidType,
         typename T8 = InvalidType,
         typename T9 = InvalidType,
         typename T10 = InvalidType,
         typename T11 = InvalidType,
         typename T12 = InvalidType,
         typename T13 = InvalidType,
         typename T14 = InvalidType,
         typename T15 = InvalidType,
         typename T16 = InvalidType,
         typename T17 = InvalidType,
         typename T18 = InvalidType,
         typename T19 = InvalidType,
         typename T20 = InvalidType
         >
struct generic_container
{
  T1 first;
  T2 second;
  T3 third;
  T4 fourth;
  T5 fifth;
  T6 sixth;
  T7 seventh;
  T8 eighth;
  T9 ninth;
  T10 tenth;
  T11 eleventh;
  T12 twelfth;
  T13 thirteenth;
  T14 fourteenth;
  T15 fifteenth;
  T16 sixteenth;
  T17 seventeenth;
  T18 eighteenth;
  T19 ninteenth;
  T20 twentieth;
};



#define G3G_DBUS_METHOD_START(methodname)     	"<method name=" #methodname "> \n"
#define G3G_DBUS_METHOD_END					 	"</method> \n"
#define G3G_DBUS_SIGNAL_START(signalname)	  	"<signal name=" #signalname "> \n"
#define G3G_DBUS_SIGNAL_END						"</signal> \n"
#define G3G_DBUS_ARG_OUT(type,name)				"<arg type=" #type " name=" #name " direction=\"out\"/> \n"
#define G3G_DBUS_ARG_IN(type,name)				"<arg type=" #type " name=" #name " direction=\"in\"/> \n"
#define G3G_DBUS_INTERFACE_START(interfacename) "<interface name=" #interfacename "> \n"
#define G3G_DBUS_INTERFACE_END					 	"</interface> \n"



#endif /* TCLDATATYPES_H_ */
